<?php

class Login extends Controller{

    public function __construct(){
        $this->UserModel = $this->loadModel('UserModel');
    }

    public function index(){
        new Template("dynamic-pages/login.html", $data=[]);
    }
    
    public function forgot_password(){
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
            $email = $_POST['email'];
            $check_email = $this->UserModel->check_email_exists($email);
            if(!$check_email){ 
                echo json_encode(['status' => 'error', 'msg' => 'Email does not exist in database']);
                return 0;
            }else{
                $password = rand(100000, 999999);
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                $user = $this->UserModel->get_user_by_mail($email);
                $update_user_password = $this->UserModel->update_password($email, $hashed_password);
                $send_mail = new Mailer([
                    'email' => $email,
                    'subject' => 'Your New Password',
                    'message' => "
                        <img src='https://cryptodigitalgrowth.com/assets/img/titan_logo.png' style='width:200px;'>
                        <h2>Hello</h2>
                        <p>Dear $username You have requested to change your password on Crypto Digital Growth</p> 
                        <p>Your new password is:</p>
                        <h4>$password</h4>
                        <p>Please copy the above characters as your new password. Thanks</p>
                        <p>&copy; 2024 <a href='cryptodigitalgrowth.com'>Crypto Digital Growth</a>. All Rights Reserved</p>
                    "
                ]);
                $send_mail->sendMessage();
                echo json_encode(['status'=>'success', 'msg'=>'New password has been sent to your email']);
            }
        }else{
            new Template("dynamic-pages/forgot-password.html", $data=[]);
        }
    }

    public function processor(){
        $authentication = new Authentication($_POST['email'], $_POST['password']);
		$auth = $authentication->authenticate();
		if($auth === true){
			//redirect("dashboard");
            echo json_encode(['status' => 'success', 'msg' => 'User Authentication Successful Proceed to OTP', 'data' => [
                //'dashboard_url' => MGT_URL.'index', //proceed to OTP instead
                'dashboard_url' => URL_ROOT.'login/verify_otp',
            ]]);
		}else{
			//display Errors
			//print "Some Errors Happened Here";
			//print "<hr>";
			//print_r($auth);
            $url = MGT_URL.'index';
            //print_r($url);
            echo json_encode(['status' => 'error', 'msg' => $auth, 'data' => [
                'dashboard_url' => MGT_URL.'index',
            ]]);
		}
    }

    public function verify_otp(){
        if($_SERVER['REQUEST_METHOD'] == 'GET'){
            $otp = rand(100000, 999999);
            $hashed_otp = password_hash($otp, PASSWORD_DEFAULT);
            $insert_otp = $this->UserModel->insert_otp($hashed_otp, $_SESSION['user_id']);
            if(!$insert_otp){
                echo json_encode(['status' => 'error', 'msg' => 'Unfortunately There is an error with OTP Generation. Try Again Later']);
                return 0;
            }
            $username = $_SESSION['username'];
            $email = $_SESSION['email'];
            //print_r([$otp]);
            $send_mail = new Mailer([
                'email' => $email,
                'subject' => 'Your One Time Password (OTP)',
                'message' => "
                <img src='https://cryptodigitalgrowth.com/assets/img/titan_logo.png' style='width:200px;'>
                <h2>Hello User ($username) </h2>
                <p>Dear $username You have initiated a Login Action on Crypto Digital Growth</p> 
                <p>Your One Time Password Is</p>
                <h4>$otp</h4>
                <p>Please copy the above characters and input them into the designated field.</p>
                <p>&copy; 2024 <a href='cryptodigitalgrowth.com'>Crypto Digital Growth</a>. All Rights Reserved</p>
                "
            ]);
            $send_mail->sendMessage();
            new Template("dynamic-pages/otp.html", $data=[]);
        }else{
            //POST REQUEST
            $otp = $_POST['OTP'];
            $user_id = $_SESSION['user_id'];
            $get_user = $this->UserModel->get_user($user_id);
            if($get_user){
                $otp_verification = password_verify($otp, $get_user->login_otp);
                if(!$otp_verification){
                    echo json_encode(['status' => 'error', 'msg'=>'OTP Verification Failed']);
                    return 0;
                }
                $delete_otp = $this->UserModel->delete_otp($user_id);
                $_SESSION['otp'] = 'verified';
                echo json_encode(['status' => 'success', 'msg'=>'OTP Verification Successful, Proceed to Dashboard', 'data'=>[
                    'dashboard_url' => MGT_URL.'index',
                ]]);
            }
        }
    }

}


?>