<?php

ini_set('display_errors',1);
error_reporting(E_ALL);

class Register extends Controller{

    public function __construct(){
        $this->RegisterModel = $this->loadModel('RegisterModel');
        $this->UserModel = $this->loadModel('UserModel');
        $this->UserProfileModel = $this->loadModel('UserProfileModel');
    }
    
    public function index(){
        return new Template("dynamic-pages/register.html", $data=[]);
    }
    
    public function verify_email(){
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
            $otp = rand(100000, 999999);
            $email = $_POST['email'];
            $username = $_POST['username'];
            $send_mail = new Mailer([
                'email' => $email,
                'subject' => 'Please verify your email address',
                'message' => "
                <img src='https://cryptodigitalgrowth.com/assets/img/titan_logo.png' style='width:200px;'>
                <h2>Hello User ($username) </h2>
                <p>Thanks for joining us</p> 
                <p>Please use the below code to verify your email address</p>
                <h4>$otp</h4>
                <p>Please copy the above characters and input them into the designated field.</p>
                <p>&copy; 2024 <a href='cryptodigitalgrowth.com'>Crypto Digital Growth</a>. All Rights Reserved</p>
                "
            ]);
            $send_mail->sendMessage();
        }
    }

    public function processor(){
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
            $username = $_POST['username'];
            $password = $_POST['password'];
            $pwd = $password;
            $telephone = $_POST['telephone'];
            $email = $_POST['email'];
            $referral = $_POST['referral'];
            $firstname = $_POST['firstname'];
            $lastname = $_POST['lastname'];
            $password = password_hash($password, PASSWORD_DEFAULT);
            $id = Uuid::guidv4();

            $check_email = $this->UserModel->check_email_exists($email);
            if($check_email){ 
                echo json_encode(['status' => 'error', 'msg' => 'User Already Registered']);
                return 0;
            }

            $insert = $this->RegisterModel->register_user($id, $username, $password, $telephone, $email, $referral, $firstname, $lastname);
            if($insert){
                $create_profile = $this->UserProfileModel->create($id);
                $mail_user = new Mailer([
                    'email' => $email,
                    'subject' => 'Welcome to Our Family',
                    'message' => "
                        <img src='https://cryptodigitalgrowth.com/assets/img/titan_logo.png' style='width:200px;'>
                        <h2>Welcome $username</h2>
                        <p>Hi $username, welcome to cryptodigitalgrowth.com! We're thrilled to have you join our growing community of investors.
                        </p>
                        <p>
                            At cryptodigitalgrowth.com, we're passionate about generating more income for you. Our platform is designed to make your investments grow 1% a day. Whether you're looking to diversify your portfolio or just earn more on your investments, cryptodigitalgrowth.com has something to offer.
                        </p>
                        <p>
                            To get started, we recommend you deposit and submit your KYC information.\n
                        If you have any questions or need assistance, our friendly support team is here to help. Don't hesitate to reach out to us at support@cryptodigitalgrowth.com 
                        </p>
                        
                        <p>
                            Here's your login information. You can revert to it anytime you have problems loggin in.
                        </p>
                        
                        <pre>
                        Username: $username
                        Password: $pwd
                        Email: $email
                        </pre>
                        
                        <p>Please keep this information safe.
                        We're excited to see what you'll accomplish on cryptodigitalinvestment.com Happy exploring!
                        </p>
                        
                        <p>&copy; 2024 <a href='cryptodigitalgrowth.com'>Crypto Digital Growth</a>. All Rights Reserved
                        </p>
                    ",
                ]);
                $mail_user->sendMessage();
                echo json_encode(['status' => 'success', 'msg'=>'User Registered Successfully']);
            }else{
                echo json_encode(['status' => 'error', 'msg'=>'User cannot be registered at the moment']);
            }
        }

    }
}

?>