<?php

class UserModel{
    public function __construct(){
        $this->db = new Database();
        $this->tbl = 'users';
    }

    public function check_email_exists($email){
        $statement = $this->db->query("SELECT * FROM $this->tbl WHERE email=?", $params=[$email], $fetchMode="fetch");
        if($statement){
            return true;
        }else{
            return false;
        }
    }
    
    public function get_user_by_mail($email){
        $statement = $this->db->query("SELECT * FROM $this->tbl WHERE email=?", $params=[$email], $fetchMode="fetch");
        if($statement){
            return $statement;
        }else{
            return false;
        }
    }
    
    public function update_password($email, $hashed_password){
        $statement = $this->db->query("UPDATE $this->tbl SET password=? WHERE email=?", $params=[$hashed_password, $email]);
        if($statement){return true;}else{return false;}
    }

    public function insert_otp($hashed_otp, $user_id){
        $statement = $this->db->query("UPDATE $this->tbl SET login_otp=? WHERE id=?", $params=[$hashed_otp, $user_id]);
        if($statement){
            return true;
        }else{
            return false;
        }
    }

    public function get_user($user_id){
        $statement = $this->db->query("SELECT * FROM $this->tbl WHERE id=?", $params=[$user_id], $fetchMode='fetch');
        if($statement){return $statement;}else{
            return false;
        }

    }

    public function delete_otp($user_id){
        $statement = $this->db->query("UPDATE $this->tbl SET login_otp=? WHERE id=?", $params=[0, $user_id]);
        if($statement){return true;}else{return false;}
    }
}


?>