<?php

class Deposit extends Controller{
    public function __construct(){
        if(!check_login()){
            $location = MAIN_WEBSITE_ADDR.'login';
            header("location: $location");
        }
        $this->InvestmentModel = $this->loadModel('InvestmentModel');
        $this->PaymentMethodModel = $this->loadModel('PaymentMethodModel');
        $this->UserProfileModel = $this->loadModel('UserProfileModel');
        $this->TransactionModel = $this->loadModel('TransactionModel');
    }

    public function wallet(){
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
            $depositAmount = $_POST['depositAmount'];
            $paymentMethod = $_POST['paymentMethod'];
            $minimumDeposit = $_POST['minimumDeposit'];
            $_SESSION['investAmount'] = $depositAmount;
            $_SESSION['paymentMethod'] = $paymentMethod;
            $url = generate_url_from_route('deposit-detail');
            echo json_encode(['status' => 'success', 'msg' => 'Proceedeing to payment', 'data' => ['url' => $url]]);


        }
    }

    public function index(){
        $payment_methods = $this->PaymentMethodModel->get_all_except_wallet();
        $data=[
            'payment_methods' => $payment_methods,
            'username' => $_SESSION['username'],
            'user_id' => $_SESSION['user_id'],
            'email' => $_SESSION['email'],
            'user_profile' => $this->UserProfileModel->get_profile($_SESSION['user_id']),
        ];
        new Template('users/deposit.html', $data);
    }

    public function history(){
        $deposits = $this->TransactionModel->get_user_deposits($_SESSION['user_id']);
        $data = [
            'username' => $_SESSION['username'],
            'user_id' => $_SESSION['user_id'],
            'email' => $_SESSION['email'],
            'user_profile' => $this->UserProfileModel->get_profile($_SESSION['user_id']),
            'deposit_wallet_balance' => $this->UserProfileModel->get_profile($_SESSION['user_id'])->total_deposit_balance,
            'deposits' => $deposits,
        ];
        new Template("users/deposit-history.html", $data);
    }

    public function manual($args){
        $investAmount = $_SESSION['investAmount'];
        $paymentMethod = $_SESSION['paymentMethod'];
        $data=[
            'username' => $_SESSION['username'],
            'user_id' => $_SESSION['user_id'],
            'email' => $_SESSION['email'],
            'requestedAmount' => $investAmount,
            'paymentMethod' => $this->PaymentMethodModel->get($paymentMethod),
            'user_profile' => $this->UserProfileModel->get_profile($_SESSION['user_id']),
            'deposit_wallet_balance' => $this->UserProfileModel->get_profile($_SESSION['user_id'])->total_deposit_balance,
        ];
        new Template('users/deposit-detail.html', $data);
    }

    public function proof(){
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
            $filename = $_FILES['file']['name'];
            //echo $filename;
            $upload = new Upload(5000000, 'uploads/evidence/', $_FILES['file']);
            $upload = $upload->upload_mixed_file_types(['jpeg', 'jpg', 'png', 'pdf']);
            if($upload){ 
                $upload_path = URL_ROOT."public/uploads/evidence/$filename";
                $id = $id = Uuid::guidv4();
                $user_id = $_SESSION['user_id'];
                $transaction_type = 'deposit';
                $transaction_date = date('Y-m-d h:i:s');
                $transaction_status = 'pending';
                $transaction_proof = $upload_path;
                $transaction_amount = $_SESSION['investAmount'];
                $payment_method = $_SESSION['paymentMethod'];
                $create_transaction = $this->TransactionModel->create($id, $user_id, $transaction_type, $transaction_date, $transaction_status, $transaction_proof, $transaction_amount, $payment_method);
                if($create_transaction){
                    echo json_encode(['status'=>'success', 'msg'=>'Payment proof uploaded successfully. Please allow for up to 12 hours for the balance to reflect in your account']);
                }else{
                    echo json_encode(['status' => 'error', 'msg'=>'Cannot create Transaction Information. Please try again']);
                }
            }else{ 
                echo json_encode(['status' => 'error', 'msg' => 'Transaction proof cannot be uploaded. Please try again']);
            }
            //echo $upload_path;
        }else{
            echo "<strong>Fatal Error</strong> Invalid Web Request";
        }

    }
}

?>