<?php

class Index extends Controller {

    public function __construct(){
        if(!check_login()){
            $location = MAIN_WEBSITE_ADDR.'login';
            header("location: $location");
        }
        $this->UserProfileModel = $this->loadModel('UserProfileModel');
        $this->TransactionModel = $this->loadModel('TransactionModel');
        $this->UserModel = $this->loadModel('UserModel');
    }

    public function index(){
        $pending_deposits = $this->TransactionModel->get_deposits($_SESSION['user_id'], 'pending');
        $total_pending_deposit = 0;
        if($pending_deposits){
            foreach($pending_deposits['data'] as $deposit){
                $total_pending_deposit += $deposit->transaction_amount;
            }
        }
        $data = [
            'username' => $_SESSION['username'],
            'user_id' => $_SESSION['user_id'],
            'email' => $_SESSION['email'],
            'user_profile' => $this->UserProfileModel->get_profile($_SESSION['user_id']),
            'firstname' => $this->UserModel->get($_SESSION['user_id'])->firstname,
        ];
        new Template("users/dashboard.html", $data);
    }
}

?>
