<?php

class Investment extends Controller{

    public function __construct(){
        if(!check_login()){
            $location = MAIN_WEBSITE_ADDR.'login';
            header("location: $location");
        }
        $this->InvestmentModel = $this->loadModel('InvestmentModel');
        $this->PaymentMethodModel = $this->loadModel('PaymentMethodModel');
        $this->UserProfileModel = $this->loadModel('UserProfileModel');
        
    }

    public function index(){
        $investments = $this->InvestmentModel->get_all_packages();
        $data = [
            'username' => $_SESSION['username'],
            'user_id' => $_SESSION['user_id'],
            'email' => $_SESSION['email'],
            'investments' => $investments,
            'user_profile' => $this->UserProfileModel->get_profile($_SESSION['user_id']),
        ];
        new Template("users/investment.html", $data);
    }

    public function detail($args){
        if(empty($args)){
            echo "<strong>Critical Error</strong> Invalid URL Parameters";
            return 0;
        }
        $investment = $this->InvestmentModel->get($args[0]);
        $payment_methods = $this->PaymentMethodModel->get_all_methods();
        $data = [
            'username' => $_SESSION['username'],
            'user_id' => $_SESSION['user_id'],
            'email' => $_SESSION['email'],
            'investment' => $investment,
            'payment_methods' => $payment_methods,
            'user_profile' => $this->UserProfileModel->get_profile($_SESSION['user_id']),
        ];
        new Template("users/investment-detail.html", $data);
    }

    public function pay(){
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
            $paymentMethod = $_POST['paymentMethod'];
            $investAmount = $_POST['investAmount'];

            $get_payment_method = $this->PaymentMethodModel->get($paymentMethod);
            //print_r($get_payment_method);
            if ($get_payment_method->designation == 1){
                //pay via wallet - //check wallet balance
                $deposit_wallet_balance = $this->UserProfileModel->get_profile($_SESSION['user_id'])->total_deposit_balance;
                if($deposit_wallet_balance < $investAmount){
                    echo json_encode(['status'=>'error', 'msg'=>'Unfortunately You do not enough balance in your Deposit Wallet to perform this investment.']);
                }
            }else{
                //pay via btc or eth
                //$url = create_http_url_Args('deposit-detail', [$investAmount, $get_payment_method->id]);
                $url = generate_url_from_route('deposit-detail');
                $_SESSION['investAmount'] = $investAmount;
                $_SESSION['paymentMethod'] = $get_payment_method->id;
                echo json_encode(['status' => 'success', 'data' => ['url' => $url]]);
            }
        }
    }
}

?>