<?php

class KYC extends Controller{
    public function __construct(){
        if(!check_login()){
            $location = MAIN_WEBSITE_ADDR.'login';
            header("location: $location");
        }
        $this->InvestmentModel = $this->loadModel('InvestmentModel');
        $this->PaymentMethodModel = $this->loadModel('PaymentMethodModel');
        $this->UserProfileModel = $this->loadModel('UserProfileModel');
        $this->TransactionModel = $this->loadModel('TransactionModel');
        $this->KYCModel = $this->loadModel('KYCModel');
    }

    public function index(){
        $data=[
            'username' => $_SESSION['username'],
            'user_id' => $_SESSION['user_id'],
            'email' => $_SESSION['email'],
            //'deposit_wallet_balance' => $this->UserProfileModel->get_user_deposit_wallet_balance($_SESSION['user_id'])->deposit_wallet_balance,
            'user_profile' => $this->UserProfileModel->get_profile($_SESSION['user_id']),
        ];
        new Template('users/kyc.html', $data);
    }

    public function submit(){
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
            $occupation = $_POST['occupation'];
            $fullname = $_POST['fullname'];
            $ssn = $_POST['ssn'];
            $dob = $_POST['dob'];
            $gender=$_POST['gender'];
            $driver_license_front = $_FILES['driver_license_front'];
            $driver_license_back = $_FILES['driver_license_back'];
            $id = Uuid::guidv4();
            $user_id = $_SESSION['user_id'];
            $address = $_POST['address'];

            $check_user_submitted = $this->KYCModel->check_user_exists($user_id);
            if($check_user_submitted->user_id){
                echo json_encode(['status'=>'error', 'msg'=>'KYC Information have been submitted by this user. Please wait for our team to verify your details']);
                return 0;
            }
            //echo $filename;
            $upload1 = new Upload(5000000, 'uploads/kyc/', $driver_license_front);
            $upload1 = $upload1->upload_mixed_file_types(['jpeg', 'jpg', 'png', 'pdf']);
            if($upload1){
                $upload2 = new Upload(5000000, 'uploads/kyc/', $driver_license_back);
                $upload2 = $upload2->upload_mixed_file_types(['jpeg', 'jpg', 'png', 'pdf']);
                if($upload2){
                    //insert data;
                    $driver_license_front_path = URL_ROOT."public/uploads/kyc/".$driver_license_front['name'];
                    $driver_license_back_path = URL_ROOT."public/uploads/kyc/".$driver_license_back['name'];
                    
                    $insert_data = $this->KYCModel->create($id, $user_id, $fullname, $occupation, $ssn, $dob, $gender, $driver_license_front_path, $driver_license_back_path, $address);
                    if($insert_data){
                        $this->UserProfileModel->set_kyc_status($user_id, 'submitted');
                        echo json_encode(['status'=>'success', 'msg' => 'KYC Application submitted successfully. Our team will verify your information as soon as possible']);
                    }else{
                        echo json_encode(['status'=>'error', 'msg'=>'KYC Application can not be submitted at this time. Please try again.']);
                    }
                }
            }else{
                echo json_encode(['status' => 'error', 'msg'=>"Driver's License (Front) cannot be uploaded. Try Again"]);
            }

        }
    }
}

?>