<?php

class Manager extends Controller{
    
    public function __construct(){
        //check_admin_details
        if(!check_admin_login()){
            redirect('manager-login');
        }
        $this->TransactionModel = $this->loadModel('TransactionModel');
        $this->UserModel = $this->loadModel('UserModel');
        $this->UserProfileModel = $this->loadModel('UserProfileModel');
        $this->WithdrawalModel = $this->loadModel('WithdrawalModel');
    }

    public function deposits(){
        $deposits = $this->TransactionModel->get_all('deposit');
        $data = [
            'deposits' => $deposits,
        ];
        new Template("administrator/deposits.html", $data);
    }
    
    public function withdrawals(){
        $withdrawals = $this->WithdrawalModel->get_all();
        $data = [
            'withdrawals' => $withdrawals,
        ];
        new Template("administrator/withdrawals.html", $data);
    }

    public function fetch_transaction_details(){
        if(isset($_GET['transaction-id'])){
            $get_transaction = $this->TransactionModel->get_transaction($_GET['transaction-id']);
            if($get_transaction){
                echo json_encode(['status'=>'success', 'msg'=>'Retrieval Successful', 'data'=>[
                    'transaction_id' => $get_transaction->id,
                    'user_id' => $get_transaction->user_id,
                    'transaction_date' => $get_transaction->transaction_date,
                    'transaction_status' => $get_transaction->transaction_status,
                    'transaction_amount' => $get_transaction->transaction_amount,
                ]]);
            }
        }
    }

    public function approve_transaction(){
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
            $id = $_POST['id'];
            $approve_transaction = $this->TransactionModel->approve_transaction($id);
            if($approve_transaction){
                echo json_encode(['status' => 'success', 'msg'=>'Transaction Approved']);
            }else{
                echo json_encode(['status' => 'error', 'msg' => 'An error occured. Transaction cannot be approved']);
            }
        }
    }

    public function reject_transaction(){
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
            $id = $_POST['id'];
            $approve_transaction = $this->TransactionModel->reject_transaction($id);
            if($approve_transaction){
                echo json_encode(['status' => 'success', 'msg'=>'User Transaction has been rejected']);
            }else{
                echo json_encode(['status' => 'error', 'msg' => 'An error occured. Action cannot be completed']);
            }
        }
    }

    public function delete_transaction(){
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
            $id= $_POST['id'];
            $delete_transaction = $this->TransactionModel->delete($id);
            if($delete_transaction){
                echo json_encode(['status' => 'success', 'msg' => 'Transaction Record Deleted Successfully']);
            }else{
                echo json_encode(['status' => 'error', 'msg' => 'An error occured, transaction cannot be deleted']);
            }
        }
    }

    public function profiles(){
        $users = $this->UserModel->get_all();
        $data = [
            'users' => $users,
        ];
        new Template("administrator/profiles.html", $data);
    }

    public function user($args){
        $user_id = $args[0];
        if(count($args) < 1){
            echo "Fatal Error: Invalid URL Parameters";
            return 0;
        }else{
            $user = $this->UserModel->get($user_id);
            $userProfile = $this->UserModel->get_profile($user_id);
            $data = [
                'user' => $user,
                'userProfile' => $userProfile,
            ];
            new Template("administrator/user-detail.html", $data);

        }
    }

    public function user_update(){
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
            $user_id = $_POST['user_id'];
            $total_deposit = $_POST['total_deposit'];
            $last_deposit = $_POST['last_deposit'];
            $pending_deposit = $_POST['pending_deposit'];
            $rejected_deposit = $_POST['rejected_deposit'];
            $total_withdraw = $_POST['total_withdraw'];
            $last_withdraw = $_POST['last_withdraw'];
            $pending_withdraw = $_POST['pending_withdraw'];
            $rejected_withdraw = $_POST['rejected_withdraw'];
            $total_interest = $_POST['total_interest'];
            $completed_interest = $_POST['completed_interest'];
            $running_interest = $_POST['running_interest'];
            $last_interest = $_POST['last_interest'];
        }
        $update = $this->UserProfileModel->update_user_info($user_id, $total_deposit, $last_deposit, $pending_deposit, $rejected_deposit, $total_withdraw, $last_withdraw,
        $pending_withdraw, $rejected_withdraw, $total_interest, $completed_interest, $running_interest, $last_interest);
        if($update){
            echo json_encode(['status'=>'success', 'msg' => 'User information updated successfully']);
        }else{
            echo json_encode(['status'=>'error', 'msg'=>'An error occured, User information cannot be updated']);
        }
    }
}

?>