<?php

class Register extends Controller{

    public function __construct(){
        $this->RegisterModel = $this->loadModel('RegisterModel');
        $this->UserModel = $this->loadModel('UserModel');
        $this->UserProfileModel = $this->loadModel('UserProfile');
    }
    
    public function index(){
        return new Template("dynamic-pages/register.html", $data=[]);
    }

    public function processor(){
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
            $username = $_POST['username'];
            $password = $_POST['password'];
            $telephone = $_POST['telephone'];
            $email = $_POST['email'];
            $password = password_hash($password, PASSWORD_DEFAULT);
            $id = Uuid::guidv4();

            $check_email = $this->UserModel->check_email_exists($email);
            if($check_email){ 
                echo json_encode(['status' => 'error', 'msg' => 'User Already Registered']);
                return 0;
            }

            $insert = $this->RegisterModel->register_user($id, $username, $password, $telephone, $email);
            if($insert){
                $create_profile = $this->UserProfileModel->create($id);
                print_r($create_profile);
                //echo json_encode(['status' => 'success', 'msg'=>'User Registered Successfully']);
            }else{
                echo json_encode(['status' => 'error', 'msg'=>'User cannot be registered at the moment']);
            }
        }

    }
}

?>