<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

class Withdraw extends Controller{
    public function __construct(){
        if(!check_login()){
            $location = MAIN_WEBSITE_ADDR.'login';
            header("location: $location");
        }
        $this->InvestmentModel = $this->loadModel('InvestmentModel');
        $this->PaymentMethodModel = $this->loadModel('PaymentMethodModel');
        $this->UserProfileModel = $this->loadModel('UserProfileModel');
        $this->TransactionModel = $this->loadModel('TransactionModel');
        $this->WithdrawalModel = $this->loadModel('WithdrawalModel');
    }

    public function index(){
        $data = [
            'username' => $_SESSION['username'],
            'user_id' => $_SESSION['user_id'],
            'email' => $_SESSION['email'],
            'payment_methods' => $this->PaymentMethodModel->get_all_except_wallet(),
            'user_profile' => $this->UserProfileModel->get_profile($_SESSION['user_id']),
        ];
        new Template("users/withdraw.html", $data);
    }
    
    public function history(){
        $withdrawals = $this->WithdrawalModel->get_all_from_user($_SESSION['user_id']);
        $data = [
            'withdrawals' => $withdrawals,
            'username' => $_SESSION['username'],
            'user_id' => $_SESSION['user_id'],
            'email' => $_SESSION['email'],
            'user_profile' => $this->UserProfileModel->get_profile($_SESSION['user_id']),
            'deposit_wallet_balance' => $this->UserProfileModel->get_profile($_SESSION['user_id'])->total_deposit_balance,
        ];
        new Template("users/withdrawal-history.html", $data);
    }
    
    public function proof(){
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
            $filename = $_FILES['file']['name'];
            //echo $filename;
            $upload = new Upload(5000000, 'uploads/evidence/', $_FILES['file']);
            $upload = $upload->upload_mixed_file_types(['jpeg', 'jpg', 'png', 'pdf']);
            if($upload){ 
                $upload_path = URL_ROOT."public/uploads/evidence/$filename";
                $id = $id = Uuid::guidv4();
                $user_id = $_SESSION['user_id'];
                $withdraw_id = $_POST['withdraw_id'];
                $transaction_date = date('Y-m-d h:i:s');
                $transaction_proof = $upload_path;
                $withdraw_charges_payment_method = $_POST['charges_payment_method'];
                $update_proof = $this->WithdrawalModel->update_proof($transaction_proof, $withdraw_charges_payment_method, $withdraw_id);
                if($update_proof){
                    echo json_encode(['status'=>'success', 'msg'=>'Payment proof uploaded successfully. Please allow for up to 12 hours for the amount to reflect in your account']);
                }else{
                    echo json_encode(['status' => 'error', 'msg'=>'Cannot create Transaction Information. Please try again']);
                }
            }else{ 
                echo json_encode(['status' => 'error', 'msg' => 'Transaction proof cannot be uploaded. Please try again']);
            }
            //echo $upload_path;
        }else{
            echo "<strong>Fatal Error</strong> Invalid Web Request";
        }

    }
    
    public function detail($args){
        $id = $args[0];
        $withdraw_detail = $this->WithdrawalModel->get($id);
        $payment_methods = $this->PaymentMethodModel->get_all_except_wallet();
        $data = [
            'withdraw' => $withdraw_detail,
            'payment_methods' => $payment_methods,
            'user_profile' => $this->UserProfileModel->get_profile($_SESSION['user_id']),
            'username' => $_SESSION['username'],
            'user_id' => $_SESSION['user_id'],
            'email' => $_SESSION['email'],
        ];
        new Template("users/withdraw-detail.html", $data);
    }
    
    public function processBank(){
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
            $bankName = $_POST['bankName'];
            $accountName = $_POST['accountName'];
            $routingNumber = $_POST['routingNumber'];
            $accountNumber = $_POST['accountNumber'];
            $withdrawAmount = $_POST['withdrawAmount'];
            $id = Uuid::guidv4();
            $user_id = $_SESSION['user_id'];
            $withdrawal_type = 'bank';
            $withdrawal_charges = 0.2*$withdrawAmount;
            $withdrawal_date = date('Y-m-d h:i:s');
            
            $insert = $this->WithdrawalModel->insert_bank($id, $user_id, $withdrawAmount, $bankName, $accountName, $accountNumber, $routingNumber, $withdrawal_type, $withdrawal_charges, $withdrawal_date);
            if($insert){
                echo json_encode(['status' => 'success', 'msg' => 'Withdrawal request submitted successfully', 'data' => ['id' => $id,]]);
            }else{
                echo json_encode(['status' => 'error', 'msg' => 'Withdrawal request cannot be submitted. Please try again']);
            }
        }
    }
    
    public function processCrypto(){
        if($_SERVER['REQUEST_METHOD'] == 'POST'){
            
            $withdrawAmount = $_POST['withdrawAmount'];
            $walletAddress = $_POST['walletAddress'];
            $paymentMethod = $_POST['paymentMethod'];
            $withdrawal_type = 'crypto';
            $withdrawal_charges = 0.2*$withdrawAmount;
            $id = Uuid::guidv4();
            $user_id = $_SESSION['user_id'];
            $withdrawal_date = date('Y-m-d h:i:s');
            
            $insert = $this->WithdrawalModel->insert_crypto($id, $paymentMethod, $withdrawAmount, $walletAddress, $withdrawal_type, $withdrawal_charges, $withdrawal_date, $user_id);
            if($insert){
                echo json_encode(['status' => 'success', 'msg' => 'Withdrawal request submitted successfully', 'data' => ['id' => $id,]]);
            }else{
                echo json_encode(['status' => 'error', 'msg' => 'Withdrawal request cannot be submitted. Please try again']);
            }
        }
    }
}

?>