<?php 

class Upload{

	public static $filePath;
	
	public function __construct($max_size, $uploadPath, $post_file_object){
		$this->max_size = $max_size;
		$this->upload_path = $uploadPath;
		$this->post_file_object = $post_file_object;
		$this->error = '';
	}


	private function uploader(array $accepted_types){
		//improve this later
		$tmp_name = $this->post_file_object['tmp_name'];
		$name = $this->post_file_object['name'];
		$full_path = $this->upload_path . $name;
		$extension = pathinfo($this->post_file_object['name'], PATHINFO_EXTENSION);
		if($this->max_size > $this->post_file_object['size'] && in_array($extension, $accepted_types)){
			if ( !file_exists($full_path)){
				move_uploaded_file($tmp_name, $full_path);
				return true;
			}else{
				$this->error .= "This file is already on the server<br>";
				self::$filePath = $full_path;
				return true;

			}
		}else{
			$this->error .= "File size too large or extension not supported<br>";
			return false;
		}
	}

	public static function filePath(){
		return self::$filePath;
	}

	public static function shredMultiple(array $multi_file_object){
		$names = $multi_file_object['name'];
		$tmp_names = $multi_file_object['tmp_name'];
		$sizes = $multi_file_object['size'];
		$types = $multi_file_object['type'];

		$count = count($names);
		$shrederObj = [];

		for($i=0; $i<$count; $i++){
			$shrederObj[] = array(
				'name'=>$names[$i],
				'tmp_name'=>$tmp_names[$i],
				'size'=>$sizes[$i],
				'type'=>$types[$i],
			);
		}

		return $shrederObj;
	}

	public function upload_picture_file(){
		$accepted_types = ['gif', 'png', 'jpg', 'jpeg'];
		$uploader = $this->uploader($accepted_types);
		if($uploader){
			return [true, self::filePath()];
		}else{
			SessionManager::flash_message($this->error);
			return false;
		}
	}

	public function upload_mixed_file_types($accepted_types){
		$uploader = $this->uploader($accepted_types);
		if($uploader){
			return [true, self::filePath()];
		}else{
			echo $this->error;
			return false;
		}
	}


	public function upload_audio_file(){
		$accepted_types = ['mp3', 'wav', 'mid'];
		$uploader = $this->uploader($accepted_types);
		if($uploader){
			return true;
		}

	}

	public function upload_zip_file(){
		$accepted_types = ['zip'];
		$uploader = $this->uploader($accepted_types);
		if($uploader){
			return true;
		}
	}

	public function upload_txt_file(){
		$accepted_types = ['txt'];
		$uploader = $this->uploader($accepted_types);
		if($uploader){
			return true;
		}
	}

	public function upload_csv_file(){
		$accepted_types = ['csv'];
		$uploader = $this->uploader($accepted_types);
		if($uploader){
			return true;
		}
	}
}

?>