<?php

class TransactionModel{
    public function __construct(){
        $this->db = new Database();
        $this->tbl = 'transactions';
    }

    public function create($id, $user_id, $transaction_type, $transaction_date, $transaction_status, $transaction_proof, $transaction_amount, $payment_method){
        $statement = $this->db->query("INSERT INTO $this->tbl (id, user_id, transaction_type, transaction_date, transaction_status, deposit_transaction_proof, transaction_amount, payment_method) VALUES(?,?,?,?,?,?,?,?)",
            $params=[$id, $user_id, $transaction_type, $transaction_date, $transaction_status, $transaction_proof, $transaction_amount, $payment_method]
        );
        if($statement){
            return true;
        }else{
            return false;
        }
    }

    public function get_user_deposits($user_id){
        $statement = $this->db->query("SELECT * FROM $this->tbl WHERE transaction_type=? AND user_id=? ORDER BY transaction_date DESC", $params=['deposit', $user_id], $fetchMode='fetchAll');
        if($statement){
            return $statement;
        }else{
            return false;
        }
    }

    public function get_deposits($user_id, $status){
        $statement = $this->db->query("SELECT * FROM $this->tbl WHERE user_id=? AND transaction_type=? AND transaction_status=?", $params=[$user_id, 'deposit', $status], $fetchMode='fetchAll');
        if($statement){return $statement;}
    }

    public function get_all($transaction_type){
        //value of transaction type should be either 'deposit' or 'withdrawal'
        $statement = $this->db->query("SELECT * FROM $this->tbl WHERE transaction_type=? ORDER BY transaction_date DESC", $params=[$transaction_type], $fetchMode='fetchAll');
        if($statement){return $statement;}else{return false;}
    }

    public function get_transaction($id){
        $statement = $this->db->query("SELECT * FROM $this->tbl WHERE id=?", $params=[$id], $fetchMode='fetch');
        if($statement){return $statement;}else{return false;}
    }

    public function approve_transaction($id){
        $statement = $this->db->query("UPDATE $this->tbl SET transaction_status=?, transaction_approved_date=? WHERE id=?", $params=['approved', date('Y-m-d h:i:s'), $id]);
        if($statement){
            return true;
        }else{
            return false;
        }
    }

    public function reject_transaction($id){
        $statement = $this->db->query("UPDATE $this->tbl SET transaction_status=?, transaction_reject_date=? WHERE id=?", $params=['rejected', date('Y-m-d h:i:s'), $id]);
        if($statement){
            return true;
        }else{
            return false;
        }
    }

    public function delete($id){
        $statement = $this->db->query("DELETE FROM $this->tbl WHERE id=?", $params=[$id]);
        if($statement){return true;}else{return false;}
    }
}

?>