<?php

class UserProfileModel{
    public function __construct(){
        $this->db = new Database();
        $this->tbl = 'user_profile';
    }

    public function create($user_id){
        $statement = $this->db->query("INSERT INTO $this->tbl (user_id) VALUES (?)", $params=[$user_id]);
        if($statement){return true;}
    }

    public function get_user_deposit_wallet_balance($user_id){
        $statement = $this->db->query("SELECT * FROM $this->tbl WHERE user_id=? ", $params=[$user_id], $fetchMode='fetch');
        if($statement){return $statement;}
    }

    public function set_kyc_status($user_id, $kyc_status){
        //kyc status must be either: pending, accepted or rejected
        $statement = $this->db->query("UPDATE $this->tbl SET kyc_status=? WHERE user_id=?", $params=[$kyc_status, $user_id]);
        if($statement){return true;}else{return false;}

    }

    public function update_user_info($user_id, $total_deposit, $last_deposit, $pending_deposit, $rejected_deposit, $total_withdraw, $last_withdraw,
        $pending_withdraw, $rejected_withdraw, $total_interest, $completed_interest, $running_interest, $last_interest){
        $statement = $this->db->query("UPDATE $this->tbl SET total_deposit_balance=?, last_deposit=?, pending_deposit=?, rejected_deposit=?, total_withdraw_balance=?, last_withdraw=?,
            pending_withdraw=?, rejected_withdraw=?, total_interest_balance=?, completed_interest=?, running_interest=?, last_interest=? WHERE user_id=?",
            $param=[$total_deposit, $last_deposit, $pending_deposit, $rejected_deposit, $total_withdraw, $last_withdraw,
            $pending_withdraw, $rejected_withdraw, $total_interest, $completed_interest, $running_interest, $last_interest, $user_id]);
        if($statement){
            return true;
        }else{
            return false;
        }

    }

    public function get_profile($user_id){
        $statement = $this->db->query("SELECT * FROM $this->tbl WHERE user_id=?", $params=[$user_id], $fetchMode='fetch');
        if($statement){return $statement;}else{return false;}
    }
}

?>