<?php

class WithdrawalModel{
    public function __construct(){
        $this->tbl = 'withdrawals';
        $this->db = new Database();
    }
    
    public function insert_crypto($id, $paymentMethod, $withdrawAmount, $walletAddress, $withdrawal_type, $withdraw_charges, $withdrawal_date, $user_id){
        $statement = $this->db->query("INSERT INTO $this->tbl(id,crypto_payment_method,withdraw_amount,wallet_address,withdrawal_type,withdraw_charges,withdrawal_date, user_id) VALUES(?,?,?,?,?,?,?,?)", $params=[$id, $paymentMethod, $withdrawAmount, $walletAddress, $withdrawal_type, $withdraw_charges, $withdrawal_date, $user_id]);
        if($statement){return true;}else{return false;}
    }
    
    public function insert_bank($id, $user_id, $withdrawAmount, $bankName, $accountName, $accountNumber, $routingNumber, $withdrawal_type, $withdrawal_charges, $withdrawal_date){
        $statement = $this->db->query("INSERT INTO $this->tbl(id, user_id, withdraw_amount, bank_name, account_name, acct_no, routing_no, withdrawal_type, withdraw_charges,withdrawal_date) VALUES(?,?,?,?,?,?,?,?,?,?)", $params=[$id, $user_id, $withdrawAmount, $bankName, $accountName, $accountNumber, $routingNumber, $withdrawal_type, $withdrawal_charges, $withdrawal_date]);
        if($statement){return true;}else{return false;}
    }
    
    public function get($id){
        $statement = $this->db->query("SELECT * FROM $this->tbl WHERE id=?", $params=[$id], $fetchMode='fetch');
        if($statement){return $statement;}else{return false;}
    }
    
    public function update_proof($payment_proof, $charges, $withdraw_id){
        $statement = $this->db->query("UPDATE $this->tbl SET payment_proof=?, withdraw_charges_payment_method=? WHERE id=?", $params=[$payment_proof, $charges, $withdraw_id]);
        if($statement){return true;}else{return false;}
    }
    
    public function get_all_from_user($user_id){
        $statement = $this->db->query("SELECT * FROM $this->tbl WHERE user_id=? ORDER BY withdrawal_date DESC", $params=[$user_id], $fetchMode='fetchAll');
        if($statement){return $statement;}else{return false;}
    }
    
    public function get_all(){
        $statement = $this->db->query("SELECT * FROM $this->tbl ORDER BY withdrawal_date DESC", $params=[], $fetchMode='fetchAll');
        if($statement){
            return $statement;
        }else{
            return false;
        }
    }
}

?>