<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>
Crypto Project
</title>
	<link rel="stylesheet" href="<?= URL_ROOT; ?>assets/tail-output.css">
	<link href="https://cdnjs.cloudflare.com/ajax/libs/flowbite/2.1.1/flowbite.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/css/splide.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.css" integrity="sha512-1cK78a1o+ht2JcaW6g8OXYwqpev9+6GqOkz9xmBN9iUUhIndKtxwILGWYOSibOKjLsEdjyjZvYDq/cZwNeak0w==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Merriweather:ital,wght@0,300;0,400;0,700;0,900;1,300;1,400;1,700;1,900&family=Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

	<link rel="stylesheet" href="<?= URL_ROOT; ?>assets/vendor/intl-tel-input-master/build/css/intlTelInput.css" />
	<script src="https://cdn.tailwindcss.com"></script>
	<link rel="stylesheet" href="<?= URL_ROOT; ?>assets/css/styles.css">
	<style>
	</style>
</head>
<body class="" oncontextmenu="return disableRight()">
	<div class="flex justify-center">
		
		<section id="sidebar" class="hidden md:block w-[20%] p-5" style="height:100vh;position:fixed;left:0;overflow-y:scroll;background:#f6f6ff;">
			<img src="<?= URL_ROOT; ?>assets/img/titan_logo.png" id="logo" class="my-20">
			<div>
				<h3 class="mb-5 font-bold text-xl text-blue-1">Account Balance</h3>
				<div class="bg-blue-500 text-white p-5 rounded-lg mb-5">
					<h3>Deposit Wallet</h3>
					<h3 class="font-bold text-3xl">&dollar;<?= $user_profile->total_deposit_balance; ?></h3>
				</div>
				<div class="bg-blue-500 text-white p-5 rounded-lg mb-5">
					<h3>Interest Wallet</h3>
					<h3 class="font-bold text-3xl">&dollar;<?= $user_profile->total_interest_balance; ?></h3>
				</div>
			</div>
			<div class="flex items-center justify-around">
				<a href="/public/App/deposit" class="py-3 text-white bg-gradient-to-r from-blue-500 via-blue-600 to-blue-700 hover:bg-gradient-to-br focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center me-2 mb-2">Deposit</a>
				<a href="/public/App/withdraw" class="py-3 text-blue-700 hover:text-white border border-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center me-2 mb-2">Withdraw</a>
			</div>
			<div class="flex justify-center mt-10" style="flex-direction:column;">
				<a href="/public/App/index" class="w-[100%] bg-blue-500 text-white p-5 rounded-lg mb-3 hover:bg-blue-800">Dashboard</a>
				<a href="/public/App/investment" class="w-[100%] bg-blue-500 text-white p-5 rounded-lg mb-3 hover:bg-blue-800">Investment</a>
				<a href="/public/App/deposit" class="w-[100%] bg-blue-500 text-white p-5 rounded-lg mb-3 hover:bg-blue-800">Deposit</a>
				<a href="/public/App/withdraw" class="w-[100%] bg-blue-500 text-white p-5 rounded-lg mb-3 hover:bg-blue-800">Withdraw</a>
				<a href="/public/App/logout" class="w-[100%] bg-blue-500 text-white p-5 rounded-lg mb-3 hover:bg-blue-800">Logout</a>
			</div>

			<div class="mt-10 text-center text-blue-1">
				<p class="text-sm">&copy; <strong>2024</strong> <?= SITE_NAME; ?></p>
			</div>
		</section>

		<section id="contentArea" class="w-[100%] md:w-[80%] ml-0 md:ml-[23%]">
			
<section id="topBar" class="flex items-center justify-between pt-2 pb-2 pr-3 pl-3 bg-blue-1">
    <div>
        <h1 class="text-white font-bold text-xl">Dashboard</h1>
    </div>
    <div class="hidden md:block w-[200px] text-white">
        <div>
            <div class="flex items-center justify-center gap-2">
                <p><?= $username; ?></p>
                <div>
                    <svg fill="white" style="width:30%;height:auto;" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg"><path d="M759.2 419.8L697.4 358 512 543.4 326.6 358l-61.8 61.8L512 667z"/></svg>
                </div>
            </div>
            
            <p class="font-bold text-sm"><?= $email; ?></p>
        </div>
    </div>
    <div class="md:hidden text-white" data-drawer-target="drawer-example" data-drawer-show="drawer-example" aria-controls="drawer-example">
        <div align="right">
            <svg style="width:20%;" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M4 6H20M4 12H20M4 18H20" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
        </div>
    </div>
</section>

<section class="p-5 pb-3">
    <h4 class="text-blue-500 font-bold text-2xl">Hello, <?= $firstname; ?></h4>
</section>

<section>
    <div class="bg-yellow-100 md:flex items-center justify-between p-2 m-3 rounded-xl" style="min-height: 50px;">
        <div>
            <div class="pl-5 hidden sm:block">
                <svg fill="#000000" style="width:20%;height:auto;" viewBox="0 0 1920 1920" xmlns="http://www.w3.org/2000/svg">
                    <path d="M960 0c530.193 0 960 429.807 960 960s-429.807 960-960 960S0 1490.193 0 960 429.807 0 960 0Zm-9.838 1342.685c-84.47 0-153.19 68.721-153.19 153.19 0 84.47 68.72 153.192 153.19 153.192s153.19-68.721 153.19-153.191-68.72-153.19-153.19-153.19ZM1153.658 320H746.667l99.118 898.623h208.755L1153.658 320Z" fill-rule="evenodd"/>
                </svg>
            </div>
        </div>
        <div class="md:flex items-center justify-center gap-5">
            
            <?php  if($user_profile->kyc_status != 'submitted'):  ?>

            <div id="kycVerification" class="mb-3 text-sm bg-yellow-500 p-5 rounded-xl cursor-pointer hover:bg-blue-600 hover:text-white">
                <h4 class="font-bold">KYC Verification Required</h4>
                <p>Submit Required KYC details to enable Withdrawals</p>
            </div>
            <?php  endif;  ?>
            
            <?php  if($user_profile->total_deposit_balance <= 0):  ?>

            <div id="emptyBalance" class="mb-3 text-sm bg-yellow-500 p-5 rounded-xl cursor-pointer hover:bg-blue-600 hover:text-white">
                <h4 class="font-bold">Empty Balance</h4>
                <p>Your balance is empty. Make deposit for your next investment.</p>
            </div>
            
            <?php  endif;  ?>

            <script>
                const kycVerification = document.querySelector("#kycVerification").addEventListener('click', function(){window.location="/public/App/KYC"});
                const emptyBalance = document.querySelector("#emptyBalance").addEventListener('click', function(){window.location="/public/App/deposit"});
            </script>

        </div>
    </div>
</section>

<section class="" id="infoCards">
    <div class="md:flex justify-center items-center gap-5 p-3" align="center">
        <div class="md:w-1/2 bg-blue-100 rounded-lg p-5 mb-5" style="height:200px;">
            <div>
                <h3>Total Deposit Balance</h3>
                <h3 class="font-bold text-3xl text-blue-1">&dollar;<?= $user_profile->total_deposit_balance; ?></h3>
            </div>
            <div class="flex items-center justify-flex-start gap-5" style="margin-top:17%;">
                <div class="p-2 rounded-md card-small-border w-1/3">
                    <h6 class="text-sm" style="font-size:.7em">Last</h6>
                    <h5 class="font-bold text-sm text-blue-1">&dollar;<?= $user_profile->last_deposit; ?></h5>
                </div>
                <div class="p-2 rounded-md card-small-border w-1/3">
                    <h5 class="text-sm" style="font-size:.7em">Pending</h5>
                    <h5 class="text-sm font-bold text-blue-1">&dollar;<?= $user_profile->pending_deposit; ?></h5>
                </div>
                <div class="p-2 rounded-md card-small-border w-1/3">
                    <h5 class="text-sm" style="font-size:.7em">Rejected</h5>
                    <h5 class="font-bold text-sm text-blue-1">&dollar;<?= $user_profile->rejected_deposit; ?></h5>
                </div>
            </div>
        </div>
        
        <div class="md:w-1/2 bg-blue-100 rounded-lg p-5 mb-5" style="height: 200px;">
            <div>
                <h3>Total Withdraw Balance</h3>
                <h3 class="font-bold text-3xl text-blue-1">&dollar;<?= $user_profile->total_withdraw_balance; ?></h3>
            </div>
            <div class="flex items-center justify-flex-start gap-5" style="margin-top:17%;">
                <div class="p-2 rounded-md card-small-border w-1/3">
                    <h6 class="text-sm" style="font-size:.6em">Last</h6>
                    <h5 class="font-bold text-sm text-blue-1">&dollar;<?= $user_profile->last_withdraw; ?></h5>
                </div>
                <div class="p-2 rounded-md card-small-border w-1/3">
                    <h5 class="text-sm" style="font-size:.7em">Pending</h5>
                    <h5 class="text-sm font-bold text-blue-1">&dollar;<?= $user_profile->pending_withdraw; ?></h5>
                </div>
                <div class="p-2 rounded-md card-small-border w-1/3">
                    <h5 class="text-sm" style="font-size:.7em">Rejected</h5>
                    <h5 class="font-bold text-sm text-blue-1">&dollar;<?= $user_profile->rejected_withdraw; ?></h5>
                </div>
            </div>
        </div>

        <div class="md:w-1/2 bg-blue-100 rounded-lg p-5 mb-5" style="height: 200px;">
            <div>
                <h3>Total Interest Balance</h3>
                <h3 class="font-bold text-3xl text-blue-1">&dollar;<?= $user_profile->total_interest_balance; ?></h3>
            </div>
            <div class="flex items-center justify-flex-start gap-5" style="margin-top:17%;">
                <div class="p-2 rounded-md card-small-border w-1/3">
                    <h6 class="text-sm" style="font-size:.7em">Completed</h6>
                    <h5 class="font-bold text-sm text-blue-1">&dollar;<?= $user_profile->completed_interest; ?></h5>
                </div>
                <div class="p-2 rounded-md card-small-border w-1/3">
                    <h5 class="text-sm" style="font-size:.7em">Running</h5>
                    <h5 class="text-sm font-bold text-blue-1">&dollar;<?= $user_profile->running_interest; ?></h5>
                </div>
                <div class="p-2 rounded-md card-small-border w-1/3">
                    <h5 class="text-sm" style="font-size:.7em">Last</h5>
                    <h5 class="font-bold text-sm text-blue-1">&dollar;<?= $user_profile->last_interest; ?></h5>
                </div>
            </div>
        </div>

    </div>
</section>

<section id="charts">
    <div class="md:flex items-center justify-center p-3 gap-10 mb-0 sm:mb-5" align="center">        
        <div class="md:w-1/2">
            <h3 class="mb-5 font-bold text-xl text-blue-1">Stock Market</h3>
            <div style="height:500px;">
                <?php  
                include('markets.html');
                 ?>
            </div>
        </div>
        <div class="md:w-1/2">
            <h3 class="mb-5 font-bold text-xl text-blue-1">Market Data</h3>
            <div style="height:500px;">
                <?php  
                include('market-data.html');
                 ?>
            </div>
        </div>
    </div>
</section>

		</section>


		

<!-- drawer init and toggle -->
<!-- drawer component -->
 <div id="drawer-example" class="fixed top-0 left-0 z-40 h-screen p-4 overflow-y-auto transition-transform -translate-x-full bg-white w-80" tabindex="-1" aria-labelledby="drawer-label">
	<h5 id="drawer-label" class="inline-flex items-center mb-4 text-base font-semibold text-gray-500"><svg class="w-4 h-4 me-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
	 <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
   </svg>Menu</h5>
	<button type="button" data-drawer-hide="drawer-example" aria-controls="drawer-example" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 absolute top-2.5 end-2.5 flex items-center justify-center" >
	   <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
		  <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
	   </svg>
	   <span class="sr-only">Close menu</span>
	</button>


	<section id="sidebar" class="block sm:hidden p-5" style="overflow-y:scroll;width:95%;">
		<img src="<?= URL_ROOT; ?>assets/img/titan_logo.png" id="logo" class="my-20">
		<div>
			<h3 class="mb-5 font-bold text-xl text-blue-1">Account Balance</h3>
			<div class="bg-blue-500 text-white p-5 rounded-lg mb-5">
				<h3>Deposit Wallet</h3>
				<h3 class="font-bold text-3xl">&dollar;<?= $user_profile->total_deposit_balance; ?></h3>
			</div>
			<div class="bg-blue-500 text-white p-5 rounded-lg mb-5">
				<h3>Interest Wallet</h3>
				<h3 class="font-bold text-3xl">&dollar;<?= $user_profile->total_interest_balance; ?></h3>
			</div>
		</div>
		<div class="flex items-center justify-around">
			<a href="/public/App/deposit" class="py-3 text-white bg-gradient-to-r from-blue-500 via-blue-600 to-blue-700 hover:bg-gradient-to-br focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center me-2 mb-2">Deposit</a>
			<a href="/public/App/withdraw" class="py-3 text-blue-700 hover:text-white border border-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center me-2 mb-2">Withdraw</a>
		</div>
		<div class="flex justify-center mt-10" style="flex-direction:column;">
			<a href="/public/App/index" class="bg-blue-500 text-white p-5 rounded-lg mb-3 hover:bg-blue-800">Dashboard</a>
			<a href="/public/App/investment" class=" bg-blue-500 text-white p-5 rounded-lg mb-3 hover:bg-blue-800">Investment</a>
			<a href="/public/App/deposit" class=" bg-blue-500 text-white p-5 rounded-lg mb-3 hover:bg-blue-800">Deposit</a>
			<a href="/public/App/withdraw" class=" bg-blue-500 text-white p-5 rounded-lg mb-3 hover:bg-blue-800">Withdraw</a>
			<a href="/public/App/logout" class=" bg-blue-500 text-white p-5 rounded-lg mb-3 hover:bg-blue-800">Logout</a>
		</div>

		<div class="mt-10 text-center text-blue-1">
			<p class="text-sm">&copy; <strong>2024</strong> <?= SITE_NAME; ?></p>
		</div>
	</section>


 </div>
 

	</div>
	<script src="https://cdn.jsdelivr.net/npm/flowbite@2.5.1/dist/flowbite.min.js"></script>

	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
	<script src="<?= URL_ROOT; ?>assets/vendor/alphanumeric-captcha/js/jquery-captcha.min.js"></script>	
	<script src="<?= URL_ROOT; ?>assets/vendor/intl-tel-input-master/build/js/intlTelInputWithUtils.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

	<script>
		function disableRight(){
			//console.log("Not Allowed");
			Swal.fire({
                title: 'Error',
                text: `Action Not Allowed`,
                icon: 'error',
                confirmButtonText: 'Okay'
            })
			return false;
		}
	</script>

	

</body>
</html>